#!perl

# AUTHOR : Ariel Chai
# VERSION : 1.00 for modo 2.01 (12.6.2006)
# DESCRIPTION : Transfers uv's between meshes with identical topology, ideal for zbrush workflow when one wants to alter uv's in the middle of a sculpture.
# USAGE : First select source mesh with UV's, then add the target mesh without uv's to the selection, make sure texture is selected, and run script.
#
#FIXME - look into &transfer overhead with layerservice querry

#---------------------------------------------------------------------------#

# Variables
my @layers = lxq("query layerservice layers ? fg");
#my @items; 
my @srcVerts;
my @srcPolys;
my @trgVerts;
my @trgVertsPos;		#2d array
my $vMap;

# Main
&init;			#initilize
&lists;			#make arrays for verts
&transfer;  #recreates uv's on target mesh

#---------------------------------------------------------------------------#

sub init {
	#terminate if number of selected layers isn't 2.
	if (@layers ne 2) {
		die("select two layers");
	}

	lx("tool.viewType uv");

	#get texture vmap
	@vMaps = lxq("query layerservice vmaps ? selected");
	foreach my $v (@vMaps) {
		$vType = lxq("query layerservice vmap.type ? $v");
		if ($vType eq texture) {
			$vMap = $v;
			last;
		}
	}
	
	if (!$vMap) {
		die("must select a texture map");
	}
}

sub lists {
	#create a list of verticles/polygons for source mesh -> and a temp list for target mesh
	lxq("query layerservice layer.index ? @layers[0]");
	@srcVerts = lxq("query layerservice verts ? all");
	@srcPolys = lxq("query layerservice polys ? all");
	lxq("query layerservice layer.index ? @layers[1]");
	@trgVerts_t = lxq("query layerservice verts ? all"); #temporary list of verts for optimize
	
	lxmonInit( $#srcVerts + $#srcPolys*10 );

	#array of positions for optimization
	lxq("query layerservice layer.index ? @layers[1]");	
	for ($j = 0; $j <= $#trgVerts_t; $j++) {
		@tPos = lxq("query layerservice vert.pos ? @trgVerts_t[$j]");
		push @trgVertsPos, [ @tPos ];
	}

	#make list of closest target verts to source
	for ($i = 0; $i <= $#srcVerts ; $i++) {
		$dist1 = -1;
		$closestID;
		lxq("query layerservice layer.index ? @layers[0]");
		@v1Pos = lxq("query layerservice vert.pos ? @srcVerts[$i]");
	
		lxq("query layerservice layer.index ? @layers[1]");	
		for ($j = 0; $j <= $#trgVerts_t; $j++) {
			@v2Pos[0,1,2] = ($trgVertsPos[$j][0],$trgVertsPos[$j][1],$trgVertsPos[$j][2]);
	  	@disp[0] = abs (@v2Pos[0] - @v1Pos[0]);
	  	@disp[1] = abs (@v2Pos[1] - @v1Pos[1]);
	  	@disp[2] = abs (@v2Pos[2] - @v1Pos[2]);
	  	
	  	#if (($dist1 eq -1) || (($disp[0] <= $dist1) && ($disp[1] <= $dist1) && ($disp[2] <= $dist1))) {
				$dist2 = sqrt((@disp[0]*@disp[0])+(@disp[1]*@disp[1])+(@disp[2]*@disp[2]));

 				if ($dist1 eq -1) { 
					$dist1 = $dist2;
					$closestID = $j;
				} elsif ($dist2 < $dist1) {
					$dist1 = $dist2;
			  	$closestID = $j;
				}
			#}

		}
			
		#add vert to list, and remove vert from temporary list
		@trgVerts[@srcVerts[$i]] = @trgVerts_t[$closestID];

	  #lxout("$i - @trgVerts_t[$closestID]");
 	  
	  splice(@trgVerts_t,$closestID,1);
		splice(@trgVertsPos,$closestID,1);

  	lxmonStep;
 	  if (!lxmonStep) { die("user Abort"); }
 
	}
}
	
sub transfer {
	#create atlas uv for target mesh3
	lx("select.item drop");
	#lx("select.item @items[1] add");
	lx("select.layer @layers[1] add");
	lx("tool.set uv.create on");
	lx("tool.attr uv.create proj atlas");
	lx("tool.doApply");
	lx("tool.set uv.create off");

	#reset all UV's
	lx("vertMap.setValue [1] [0] 0");
	lx("vertMap.setValue [1] [1] 0");
	
	#iterate through polys on source and fix
	foreach my $p1 (@srcPolys) {
		$p = lxq("query layerservice poly.index ? @srcPolys[$p1]");

		#get verticles contained in poly
		lxq("query layerservice layer.id ? @layers[0]");
		@polyVerts = lxq("query layerservice poly.vertList ? $p");
		@vmapPoly = lxq("query layerservice poly.vmapValue ? $p");

		#select closest verts on target mesh
		lx("select.typeFrom vertex");
		lx("select.drop vertex");
		foreach my $v (@polyVerts) {
			lx("select.element @layers[1] vertex add @trgVerts[@srcVerts[$v]]");
		}

		#isolate poly
		lx("select.convert polygon");
		lx("select.type polygon");
		lxq("query layerservice layer.id ? @layers[1]");
		if (lxq("query layerservice poly.N ? selected") eq 0) { 
			lxout("polyVerts: @polyVerts");
			die("mesh is too far apart for transfer"); 
		}
		lxq("query layerservice layer.id ? @layers[1]");
		$trgPoly = lxq("query layerservice polys ? selected");
		lx("select.typeFrom polygon");
		lx("select.drop polygon");
		lx("select.element @layers[1] polygon add $trgPoly");
		lx("hide.unsel");

		lxq("query layerservice layer.id ? @layers[0]");
		for ($i = 0; $i <= $#polyVerts ; $i++) {
			$v = @polyVerts[$i];
			@vmapPos[0] = @vmapPoly[$i*2];
			@vmapPos[1] = @vmapPoly[$i*2+1];
			
			#lx("select.convert vertex");
			lx("select.type vertex");
			lx("select.drop vertex");
			lx("select.element @layers[1] vertex add @trgVerts[$v]");		

			#FIXME - UV WINDOW HAS TO BE CLICKED FOR THIS TO WORK	
			lx("tool.set xfrm.move on");
			lx("tool.setAttr xfrm.move U @vmapPos[0]");
			lx("tool.setAttr xfrm.move V @vmapPos[1]");
			lx("tool.doApply");
			lx("tool.set xfrm.move off");
		}			

		lx("unhide");
	
		lxmonStep(10);
	 	if (!lxmonStep) { die("user Abort"); }	
	}
}